/*
 * Decompiled with CFR 0.152.
 */
package studiplayer.audio;

import java.io.File;
import studiplayer.audio.NotPlayableException;

public abstract class AudioFile {
    String author = "";
    String title = "";
    String pathname = "";

    public String getPathname() {
        return this.pathname;
    }

    public AudioFile(String pathn) throws NotPlayableException {
        try {
            this.pathname = pathn;
            File test = new File(this.pathname);
            this.kurze(this.getPathname());
            if (!test.canRead()) {
                throw new RuntimeException("Datei " + this.pathname + " nicht lesbar");
            }
        }
        catch (Exception e) {
            throw new NotPlayableException(this.getPathname(), e);
        }
    }

    public void kurze(String dateipfad) {
        if (dateipfad.contains("/") || dateipfad.contains("\\")) {
            String cut = dateipfad.substring(dateipfad.lastIndexOf(File.separatorChar));
            dateipfad = cut.substring(1, cut.lastIndexOf("."));
        } else {
            dateipfad = dateipfad.substring(0, dateipfad.lastIndexOf("."));
        }
        dateipfad = dateipfad.trim();
        while (dateipfad.contains("  ")) {
            dateipfad = dateipfad.replace("  ", " ");
        }
        int laenge = dateipfad.length();
        if (dateipfad.contains(" - ")) {
            String[] trennung = dateipfad.split("\\ - ");
            if (trennung[1].length() + trennung[0].length() < laenge - 3) {
                System.out.println("Fehler, undefinierbar, wegen Gedankenstrich in Lied/Titel!");
            } else {
                this.author = trennung[0];
                this.title = trennung[1];
            }
        } else {
            this.title = dateipfad;
            this.author = "";
        }
    }

    public String toString() {
        String erg = "";
        if (!this.author.isEmpty()) {
            erg = String.valueOf(this.author) + " - " + this.title;
        }
        if (this.author.isEmpty()) {
            erg = this.title;
        }
        return erg;
    }

    public abstract void play() throws NotPlayableException;

    public abstract void togglePause();

    public abstract void stop();

    public abstract String getFormattedDuration();

    public abstract String getFormattedPosition();

    public abstract String[] fields();
}

