/*
 * Decompiled with CFR 0.152.
 */
package studiplayer.audio;

import junit.framework.TestCase;
import studiplayer.audio.AudioFile;
import studiplayer.audio.AudioFileFactory;
import studiplayer.audio.NotPlayableException;
import studiplayer.audio.TaggedFile;
import studiplayer.audio.WavFile;

public class AudioFileFactoryTest
extends TestCase {
    public void testFactory() {
        try {
            AudioFile f1 = AudioFileFactory.getInstance("Rock 812.mp3");
            AudioFileFactoryTest.assertEquals((String)"MP3-Typ nicht erkannt", (String)"studiplayer.audio.TaggedFile", (String)f1.getClass().getName());
            AudioFile f2 = AudioFileFactory.getInstance("wellenmeister - tranquility.wav");
            AudioFileFactoryTest.assertEquals((String)"WAV-Typ nicht erkannt", (String)"studiplayer.audio.WavFile", (String)f2.getClass().getName());
            AudioFile f3 = AudioFileFactory.getInstance("wellenmeister_awakening.ogg");
            AudioFileFactoryTest.assertEquals((String)"OGG-Typ nicht erkannt", (String)"studiplayer.audio.TaggedFile", (String)f3.getClass().getName());
            AudioFile f4 = AudioFileFactory.getInstance("wellenmeister_awakening.oGg");
            AudioFileFactoryTest.assertEquals((String)"OGG-Typ nicht erkannt", (String)"studiplayer.audio.TaggedFile", (String)f4.getClass().getName());
            AudioFile f5 = AudioFileFactory.getInstance("kein.wav.sondern.ogg");
            AudioFileFactoryTest.assertTrue((String)"Ueberpruefung auf DateiENDUNG nicht korrekt", (boolean)(f5 instanceof TaggedFile));
            AudioFile f6 = AudioFileFactory.getInstance("kein.ogg.sondern.wav");
            AudioFileFactoryTest.assertTrue((String)"Ueberpruefung auf DateiENDUNG nicht korrekt", (boolean)(f6 instanceof WavFile));
        }
        catch (NotPlayableException e) {
            AudioFileFactoryTest.fail((String)"AudioFileFactory kann kein AudioFile erzeugen");
        }
    }

    public void testException() {
        try {
            AudioFileFactory.getInstance("does not exist.mp3");
            AudioFileFactoryTest.fail((String)"Haette Exception ausloesen sollen");
        }
        catch (NotPlayableException e) {
            AudioFileFactoryTest.assertTrue((boolean)true);
        }
    }
}

