/*
 * Decompiled with CFR 0.152.
 */
package studiplayer.audio;

import java.text.DecimalFormat;
import studiplayer.audio.AudioFile;
import studiplayer.audio.NotPlayableException;
import studiplayer.basic.BasicPlayer;

abstract class SampledFile
extends AudioFile {
    long duration = 0L;

    public long getDuration() {
        return this.duration;
    }

    public SampledFile(String var) throws NotPlayableException {
        super(var);
    }

    @Override
    public void play() throws NotPlayableException {
        try {
            BasicPlayer.play((String)this.pathname);
        }
        catch (Exception e) {
            throw new NotPlayableException(this.getPathname(), e);
        }
    }

    @Override
    public void togglePause() {
        BasicPlayer.togglePause();
    }

    @Override
    public void stop() {
        BasicPlayer.stop();
    }

    @Override
    public String getFormattedDuration() {
        String dura = this.returnerg(this.duration);
        return dura;
    }

    @Override
    public String getFormattedPosition() {
        long position = BasicPlayer.getPosition();
        String erg = this.returnerg(position);
        return erg.trim();
    }

    private String returnerg(long zeit) {
        DecimalFormat df = new DecimalFormat();
        df.setMinimumIntegerDigits(2);
        int ss = (int)(zeit / 1000000L % 60L);
        int mm = (int)(zeit / 1000000L / 60L);
        String erg = String.valueOf(df.format(mm)) + ":" + df.format(ss);
        return erg;
    }
}

