/*
 * Decompiled with CFR 0.152.
 */
package studiplayer.audio;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.TestCase;
import studiplayer.audio.NotPlayableException;
import studiplayer.audio.SampledFile;
import studiplayer.audio.TaggedFile;
import studiplayer.audio.WavFile;
import studiplayer.basic.BasicPlayer;

public class SampledFileTest
extends TestCase {
    private Class clazz = SampledFile.class;
    private SampledFile f1;
    private SampledFile f2;
    private SampledFile f3;

    public SampledFileTest() {
        try {
            this.f1 = new TaggedFile("Rock 812.mp3");
            this.f2 = new WavFile("wellenmeister - tranquility.wav");
            this.f3 = new TaggedFile("wellenmeister_awakening.ogg");
        }
        catch (NotPlayableException e) {
            e.printStackTrace();
        }
    }

    public void testSuperClass() {
        SampledFileTest.assertEquals((String)"SampledFile nicht von AudioFile abgeleitet", (String)"studiplayer.audio.AudioFile", (String)this.clazz.getSuperclass().getName());
    }

    public void testAbstract() {
        int mod = this.clazz.getModifiers();
        SampledFileTest.assertTrue((String)"AudioFile nicht abstrakt", (boolean)Modifier.isAbstract(mod));
    }

    public void testAttributes() {
        try {
            Field fieldDuration = this.clazz.getDeclaredField("duration");
            SampledFileTest.assertEquals((String)"duration ist kein long", (String)"long", (String)fieldDuration.getType().getName());
            int mod = fieldDuration.getModifiers();
            SampledFileTest.assertFalse((String)"Zugriff auf duration beschaenken", (Modifier.isProtected(mod) || Modifier.isPublic(mod) ? 1 : 0) != 0);
        }
        catch (SecurityException e) {
            SampledFileTest.fail((String)e.toString());
        }
        catch (NoSuchFieldException e) {
            SampledFileTest.fail((String)"Ein gefordertes Attribut existiert nicht.");
        }
    }

    public void testConstructor() {
        try {
            Constructor ctor = this.clazz.getDeclaredConstructor(String.class);
        }
        catch (SecurityException e) {
            SampledFileTest.fail((String)e.toString());
        }
        catch (NoSuchMethodException e) {
            SampledFileTest.fail((String)"SampledFile(String) gibt es nicht");
        }
    }

    public void testCommonFunctionality() {
        Method[] methods;
        Method[] methodArray = methods = this.clazz.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            int mod;
            Class<?>[] params;
            Method method = methodArray[n2];
            if (method.getReturnType().equals(String.class) && (params = method.getParameterTypes()).length == 1 && params[0].equals(Long.TYPE) && Modifier.isPrivate(mod = method.getModifiers())) {
                method.setAccessible(true);
                try {
                    SampledFileTest.assertEquals((String)"Helper-Routine zum Formatieren der Mikrosekunden", (Object)"05:01", (Object)method.invoke((Object)this.f1, new Long(301360200L)));
                }
                catch (IllegalArgumentException e) {
                    SampledFileTest.fail((String)e.toString());
                }
                catch (IllegalAccessException e) {
                    SampledFileTest.fail((String)e.toString());
                }
                catch (InvocationTargetException e) {
                    SampledFileTest.fail((String)e.toString());
                }
                return;
            }
            ++n2;
        }
        SampledFileTest.fail((String)"Gemeinsame Funktionalitaet von getFormattedPosition und getFormattedDuration in private Methode auslagern  (kein Copy-and-Paste-Code)");
    }

    public void testFormattedDuration() {
        try {
            SampledFileTest.assertEquals((String)"Falsche Formatierung durch SampledFile.getFormattedDuration", (String)"05:31", (String)this.f1.getFormattedDuration());
            Field fieldDuration = this.clazz.getDeclaredField("duration");
            fieldDuration.setAccessible(true);
            fieldDuration.setLong(this.f1, 301360200L);
            SampledFileTest.assertEquals((String)"Falsche Formatierung durch SampledFile.getFormattedDuration", (String)"05:01", (String)this.f1.getFormattedDuration());
        }
        catch (SecurityException e) {
            SampledFileTest.fail((String)e.toString());
        }
        catch (NoSuchFieldException e) {
            SampledFileTest.fail((String)"Ein gefordertes Attribut existiert nicht.");
        }
        catch (IllegalArgumentException e) {
            SampledFileTest.fail((String)e.toString());
        }
        catch (IllegalAccessException e) {
            SampledFileTest.fail((String)e.toString());
        }
    }

    public void testDurationRetrieval() {
        try {
            Field fieldDuration = this.clazz.getDeclaredField("duration");
            fieldDuration.setAccessible(true);
            SampledFileTest.assertTrue((String)"Attribut duration hat falschen Wert (WAV)", (Math.abs(141400816L - fieldDuration.getLong(this.f2)) < 100000L ? 1 : 0) != 0);
            SampledFileTest.assertEquals((String)"Attribut duration hat falschen Wert (TaggedFile)", (long)355154000L, (long)fieldDuration.getLong(this.f3));
        }
        catch (SecurityException e) {
            SampledFileTest.fail((String)e.toString());
        }
        catch (NoSuchFieldException e) {
            SampledFileTest.fail((String)"Ein gefordertes Attribut existiert nicht.");
        }
        catch (IllegalArgumentException e) {
            SampledFileTest.fail((String)e.toString());
        }
        catch (IllegalAccessException e) {
            SampledFileTest.fail((String)e.toString());
        }
    }

    public void testPlayPauseStop() {
        long pos1 = BasicPlayer.getPosition();
        SampledFileTest.assertEquals((String)"Abspielposition falsch", (long)0L, (long)pos1);
        new Thread(){

            @Override
            public void run() {
                try {
                    SampledFileTest.this.f1.play();
                }
                catch (NotPlayableException e) {
                    SampledFileTest.fail((String)("Abspielfehler " + SampledFileTest.this.f1));
                }
            }
        }.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.f1.togglePause();
        long pos2 = BasicPlayer.getPosition();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SampledFileTest.assertTrue((String)"Abspielposition falsch", (pos1 < pos2 ? 1 : 0) != 0);
        long pos2x = BasicPlayer.getPosition();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long pos3 = BasicPlayer.getPosition();
        SampledFileTest.assertEquals((String)"Abspielposition falsch", (long)pos2x, (long)pos3);
        this.f1.togglePause();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long pos4 = BasicPlayer.getPosition();
        SampledFileTest.assertTrue((String)"Abspielposition falsch", (pos3 < pos4 ? 1 : 0) != 0);
        this.f1.stop();
        long pos5 = BasicPlayer.getPosition();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long pos6 = BasicPlayer.getPosition();
        SampledFileTest.assertEquals((String)"Abspielposition falsch", (long)pos5, (long)pos6);
    }
}

