/*
 * Decompiled with CFR 0.152.
 */
package studiplayer.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import studiplayer.audio.AudioFile;
import studiplayer.audio.AudioFileFactory;
import studiplayer.audio.NotPlayableException;
import studiplayer.audio.PlayList;
import studiplayer.audio.SortCriterion;
import studiplayer.ui.Player;

class PlayListEditor
extends JFrame
implements ActionListener,
MouseListener {
    private PlayList playList;
    private Player player;
    private static final String AC_ADD = "add";
    private static final String AC_SUB = "sub";
    private static final String AC_RAND = "rand";
    private PlayListTableModel model;
    private JTable table;
    private String lastDir;
    private JButton random;
    private boolean rand = false;
    ImageIcon seqIcon = new ImageIcon(this.getClass().getResource("random_no.png"));
    ImageIcon randIcon = new ImageIcon(this.getClass().getResource("random.png"));

    PlayListEditor(Player player, PlayList playList) {
        this.player = player;
        this.playList = playList;
        this.setDefaultCloseOperation(1);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setTitle("Playlist - " + playList.size() + " Songs");
        this.model = new PlayListTableModel();
        this.table = new JTable(this.model);
        this.table.setToolTipText("Einfachklick selektiert, Doppelklick spielt");
        this.table.getColumnModel().getColumn(0).setHeaderValue("Interpret");
        this.table.getColumnModel().getColumn(1).setHeaderValue("Titel");
        this.table.getColumnModel().getColumn(2).setHeaderValue("Album");
        this.table.getColumnModel().getColumn(3).setHeaderValue("L\u221a\u00a7nge");
        this.table.addMouseListener(this);
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PlayListEditor.this.model.sortByColumn(PlayListEditor.this.table.columnAtPoint(evt.getPoint()));
            }
        });
        this.add(new JScrollPane(this.table));
        JPanel bottomPanel = new JPanel();
        JButton add = new JButton(new ImageIcon(this.getClass().getResource("add.png")));
        add.setActionCommand(AC_ADD);
        add.addActionListener(this);
        add.setToolTipText("Eintrag zur Playlist hinzuf\u221a\u00bagen");
        JButton sub = new JButton(new ImageIcon(this.getClass().getResource("sub.png")));
        sub.setActionCommand(AC_SUB);
        sub.addActionListener(this);
        sub.setToolTipText("Auswahl aus Playlist entfernen");
        this.random = new JButton(this.seqIcon);
        this.random.setActionCommand(AC_RAND);
        this.random.addActionListener(this);
        this.random.setToolTipText("Zufallsmodus aus/ein");
        bottomPanel.add(add);
        bottomPanel.add(sub);
        bottomPanel.add(this.random);
        this.add((Component)bottomPanel, "South");
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(AC_ADD)) {
            JFileChooser fileChooser = new JFileChooser(this.lastDir);
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    String[] knownExts = new String[]{".wav", ".mp3", ".ogg"};
                    String lc = f.getName().toLowerCase();
                    if (f.isDirectory()) {
                        return true;
                    }
                    String[] stringArray = knownExts;
                    int n = knownExts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        if (lc.endsWith(s)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    return "Sound-Dateien";
                }
            });
            int returnVal = fileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                try {
                    File[] files;
                    File[] fileArray = files = fileChooser.getSelectedFiles();
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        this.playList.add(AudioFileFactory.getInstance(f.getAbsolutePath()));
                        ++n2;
                    }
                }
                catch (NotPlayableException ex) {
                    ex.printStackTrace();
                }
                this.lastDir = fileChooser.getSelectedFile().getParent();
            }
            this.updateTable();
        } else if (cmd.equals(AC_SUB)) {
            int row = this.table.getSelectedRow();
            if (row < 0) {
                return;
            }
            this.playList.remove(row);
            this.updateTable();
        } else if (cmd.equals(AC_RAND)) {
            this.rand = !this.rand;
            this.playList.setRandomOrder(this.rand);
            if (this.rand) {
                this.random.setIcon(this.randIcon);
            } else {
                this.random.setIcon(this.seqIcon);
            }
        }
    }

    private void updateTable() {
        this.model.fireTableDataChanged();
        this.setTitle("Playlist - " + this.playList.size() + " Songs");
        this.playList.saveAsM3U("playList.m3u");
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        if (arg0.getClickCount() > 1) {
            this.playList.setCurrent(this.table.getSelectedRow());
            this.player.actionPerformed(new ActionEvent(this.player, 0, "AC_STOP"));
            this.player.actionPerformed(new ActionEvent(this.player, 0, "AC_PLAY"));
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    private class PlayListTableModel
    extends AbstractTableModel {
        private PlayListTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return PlayListEditor.this.playList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return ((AudioFile)PlayListEditor.this.playList.get(rowIndex)).fields()[columnIndex];
        }

        public void sortByColumn(int clm) {
            if (clm == 0) {
                PlayListEditor.this.playList.sort(SortCriterion.AUTHOR);
            } else if (clm == 1) {
                PlayListEditor.this.playList.sort(SortCriterion.TITLE);
            } else if (clm == 2) {
                PlayListEditor.this.playList.sort(SortCriterion.ALBUM);
            } else if (clm == 3) {
                PlayListEditor.this.playList.sort(SortCriterion.DURATION);
            }
        }
    }
}

