/*
 * Decompiled with CFR 0.152.
 */
package studiplayer.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import junit.framework.TestCase;
import studiplayer.audio.AudioFile;
import studiplayer.audio.PlayList;
import studiplayer.ui.PlayListEditor;
import studiplayer.ui.Player;

public class PlayerTest
extends TestCase {
    private Class<Player> clazz = Player.class;
    private static final String PLAY = "play";
    private static final String PAUSE = "pause";
    private static final String STOP = "stop";
    private static final String NEXT = "next";
    private static final String EDITOR = "editor";
    private static final String UNKNOWN = "unknown";

    public void testAttributes() {
        Hashtable<String, String> hm = new Hashtable<String, String>();
        hm.put("songDescription", "javax.swing.JLabel");
        hm.put("playTime", "javax.swing.JLabel");
        hm.put("stopped", "boolean");
        hm.put("DEFAULT_PLAYLIST", "java.lang.String");
        hm.put("playList", "studiplayer.audio.PlayList");
        hm.put("playListEditor", "studiplayer.ui.PlayListEditor");
        String attr = null;
        try {
            Iterator iterator = hm.keySet().iterator();
            while (iterator.hasNext()) {
                String attribut;
                attr = attribut = (String)iterator.next();
                Field f = this.clazz.getDeclaredField(attribut);
                f.setAccessible(true);
                PlayerTest.assertEquals((String)("Typ des Attributs " + attribut), (String)((String)hm.get(attribut)), (String)f.getType().getName());
                if ("DEFAULT_PLAYLIST".equals(attribut)) continue;
                int mod = f.getModifiers();
                PlayerTest.assertTrue((String)("Zugriff auf " + attribut + " einschraenken"), (boolean)Modifier.isPrivate(mod));
            }
        }
        catch (SecurityException e) {
            PlayerTest.fail((String)"whatever");
        }
        catch (NoSuchFieldException e) {
            PlayerTest.fail((String)("Attribut " + attr + " existiert nicht."));
        }
        PlayerTest.assertEquals((String)"Wert falsch", (String)"playList.m3u", (String)"playList.m3u");
    }

    public void testConstructor() {
        Field fieldPlayList;
        Player player;
        try {
            player = new Player(new PlayList());
            fieldPlayList = this.clazz.getDeclaredField("playList");
            fieldPlayList.setAccessible(true);
            PlayList pl1 = (PlayList)fieldPlayList.get(player);
            PlayerTest.assertEquals((String)"PlayList nicht-leer", (int)0, (int)pl1.size());
            player.dispose();
        }
        catch (NoSuchFieldException e) {
            PlayerTest.fail((String)"Kein playList-Attribut");
        }
        catch (IllegalAccessException e) {
            PlayerTest.fail((String)e.toString());
        }
        try {
            player = new Player(new PlayList("playList2.m3u"));
            fieldPlayList = this.clazz.getDeclaredField("playList");
            fieldPlayList.setAccessible(true);
            PlayList pl2 = (PlayList)fieldPlayList.get(player);
            PlayerTest.assertEquals((String)"Anzahl Lieder in PlayList", (int)8, (int)pl2.size());
            Field fieldPlayListEditor = this.clazz.getDeclaredField("playListEditor");
            fieldPlayListEditor.setAccessible(true);
            PlayListEditor ple = (PlayListEditor)fieldPlayListEditor.get(player);
            PlayerTest.assertNotNull((String)"PlayListEditor nicht erzeugt", (Object)ple);
            AudioFile currentSong = pl2.getCurrentAudioFile();
            PlayerTest.assertNotNull((String)"currentSong nicht gesetzt", (Object)currentSong);
            PlayerTest.assertEquals((String)"currentSong falsch", (String)"Wellenmeister - TANOM Part I: Awakening - TheAbsoluteNecessityOfMeaning - 05:55", (String)currentSong.toString());
            Field fieldSongDescription = this.clazz.getDeclaredField("songDescription");
            fieldSongDescription.setAccessible(true);
            JLabel songDescription = (JLabel)fieldSongDescription.get(player);
            PlayerTest.assertEquals((String)"songDescription falsch", (String)currentSong.toString(), (String)songDescription.getText());
            PlayerTest.assertEquals((String)"Titel falsch", (String)currentSong.toString(), (String)player.getTitle());
            player.dispose();
        }
        catch (NoSuchFieldException e) {
            PlayerTest.fail((String)"Kein playList-Attribut");
        }
        catch (IllegalAccessException e) {
            PlayerTest.fail((String)e.toString());
        }
    }

    public void testButtonLayout() {
        Player player = new Player(new PlayList("playList2.m3u"));
        HashMap<String, JButton> buttonList = this.fillButtonList(player);
        PlayerTest.assertEquals((String)"Anzahl Buttons falsch", (int)5, (int)buttonList.size());
        String cmdString = "@";
        for (Map.Entry<String, JButton> entry : buttonList.entrySet()) {
            JButton button = entry.getValue();
            String cmd = button.getActionCommand();
            PlayerTest.assertFalse((String)"Kein Action Command gesetzt", (boolean)"".equals(cmd));
            PlayerTest.assertTrue((String)"Zweimal gleiches Action Command", (cmdString.indexOf("@" + cmd + "@") < 0 ? 1 : 0) != 0);
            cmdString = String.valueOf(cmdString) + cmd + "@";
        }
        PlayerTest.assertNotNull((String)"Kein Button fuer Abspielen", (Object)buttonList.get(PLAY));
        PlayerTest.assertNotNull((String)"Kein Button fuer Pausieren", (Object)buttonList.get(PAUSE));
        PlayerTest.assertNotNull((String)"Kein Button fuer Anhalten", (Object)buttonList.get(STOP));
        PlayerTest.assertNotNull((String)"Kein Button fuer Ueberspringen", (Object)buttonList.get(NEXT));
        PlayerTest.assertNotNull((String)"Kein Button fuer PlayList-Editor", (Object)buttonList.get(EDITOR));
        PlayerTest.assertNull((String)"Fehlendes oder falsches Icon zu Button", (Object)buttonList.get(UNKNOWN));
        player.dispose();
    }

    public void testButtons() {
        String eventSequence = "Aktionen: <start>";
        Player player = new Player(new PlayList("playList2.m3u"));
        HashMap<String, JButton> buttonList = this.fillButtonList(player);
        JButton play = buttonList.get(PLAY);
        JButton pause = buttonList.get(PAUSE);
        JButton stop = buttonList.get(STOP);
        JButton next = buttonList.get(NEXT);
        PlayerTest.assertTrue((String)(String.valueOf(eventSequence) + " Play nicht aktiviert"), (boolean)play.isEnabled());
        PlayerTest.assertFalse((String)(String.valueOf(eventSequence) + " Pause aktiviert"), (boolean)pause.isEnabled());
        PlayerTest.assertFalse((String)(String.valueOf(eventSequence) + " Stop aktiviert"), (boolean)stop.isEnabled());
        PlayerTest.assertTrue((String)(String.valueOf(eventSequence) + " Next nicht aktiviert"), (boolean)next.isEnabled());
        eventSequence = String.valueOf(eventSequence) + "<play1>";
        player.actionPerformed(new ActionEvent(player, 0, play.getActionCommand()));
        PlayerTest.assertFalse((String)(String.valueOf(eventSequence) + " Play aktiviert"), (boolean)play.isEnabled());
        PlayerTest.assertTrue((String)(String.valueOf(eventSequence) + " Pause nicht aktiviert"), (boolean)pause.isEnabled());
        PlayerTest.assertTrue((String)(String.valueOf(eventSequence) + " Stop nicht aktiviert"), (boolean)stop.isEnabled());
        PlayerTest.assertTrue((String)(String.valueOf(eventSequence) + " Next nicht aktiviert"), (boolean)next.isEnabled());
        this.mySleep(1000L);
        eventSequence = String.valueOf(eventSequence) + "<pause>";
        player.actionPerformed(new ActionEvent(player, 0, pause.getActionCommand()));
        PlayerTest.assertFalse((String)(String.valueOf(eventSequence) + " Play aktiviert"), (boolean)play.isEnabled());
        PlayerTest.assertTrue((String)(String.valueOf(eventSequence) + " Pause nicht aktiviert"), (boolean)pause.isEnabled());
        PlayerTest.assertTrue((String)(String.valueOf(eventSequence) + " Stop nicht aktiviert"), (boolean)stop.isEnabled());
        PlayerTest.assertTrue((String)(String.valueOf(eventSequence) + " Next nicht aktiviert"), (boolean)next.isEnabled());
        this.mySleep(1000L);
        eventSequence = String.valueOf(eventSequence) + "<play2>";
        player.actionPerformed(new ActionEvent(player, 0, play.getActionCommand()));
        PlayerTest.assertFalse((String)(String.valueOf(eventSequence) + " Play aktiviert"), (boolean)play.isEnabled());
        PlayerTest.assertTrue((String)(String.valueOf(eventSequence) + " Pause nicht aktiviert"), (boolean)pause.isEnabled());
        PlayerTest.assertTrue((String)(String.valueOf(eventSequence) + " Stop nicht aktiviert"), (boolean)stop.isEnabled());
        PlayerTest.assertTrue((String)(String.valueOf(eventSequence) + " Next nicht aktiviert"), (boolean)next.isEnabled());
        this.mySleep(1000L);
        eventSequence = String.valueOf(eventSequence) + "<stop1>";
        player.actionPerformed(new ActionEvent(player, 0, stop.getActionCommand()));
        PlayerTest.assertTrue((String)(String.valueOf(eventSequence) + " Play nicht aktiviert"), (boolean)play.isEnabled());
        PlayerTest.assertFalse((String)(String.valueOf(eventSequence) + " Pause aktiviert"), (boolean)pause.isEnabled());
        PlayerTest.assertFalse((String)(String.valueOf(eventSequence) + " Stop aktiviert"), (boolean)stop.isEnabled());
        PlayerTest.assertTrue((String)(String.valueOf(eventSequence) + " Next nicht aktiviert"), (boolean)next.isEnabled());
        try {
            Field fieldPlayTime = this.clazz.getDeclaredField("playTime");
            fieldPlayTime.setAccessible(true);
            JLabel ptime = (JLabel)fieldPlayTime.get(player);
            PlayerTest.assertEquals((String)(String.valueOf(eventSequence) + " Stop setzt playTime nicht zurueck"), (String)"00:00", (String)ptime.getText());
            Field fieldPlaylist = this.clazz.getDeclaredField("playList");
            fieldPlaylist.setAccessible(true);
            PlayList pl = (PlayList)fieldPlaylist.get(player);
            AudioFile currentSong = pl.getCurrentAudioFile();
            PlayerTest.assertNotNull((String)(String.valueOf(eventSequence) + " currentSong nicht gesetzt"), (Object)currentSong);
            PlayerTest.assertEquals((String)(String.valueOf(eventSequence) + " currentSong falsch"), (String)"Wellenmeister - TANOM Part I: Awakening - TheAbsoluteNecessityOfMeaning - 05:55", (String)currentSong.toString());
        }
        catch (NoSuchFieldException e) {
            PlayerTest.fail((String)("Attribut existiert nicht " + e));
        }
        catch (IllegalAccessException e) {
            PlayerTest.fail((String)e.toString());
        }
        this.mySleep(1000L);
        eventSequence = String.valueOf(eventSequence) + "<next1>";
        player.actionPerformed(new ActionEvent(player, 0, next.getActionCommand()));
        this.mySleep(1000L);
        eventSequence = String.valueOf(eventSequence) + "<play3>";
        player.actionPerformed(new ActionEvent(player, 0, play.getActionCommand()));
        this.mySleep(1000L);
        eventSequence = String.valueOf(eventSequence) + "<next2>";
        player.actionPerformed(new ActionEvent(player, 0, next.getActionCommand()));
        try {
            Field fieldPlaylist = this.clazz.getDeclaredField("playList");
            fieldPlaylist.setAccessible(true);
            PlayList pl = (PlayList)fieldPlaylist.get(player);
            AudioFile currentSong = pl.getCurrentAudioFile();
            Field fieldPlayTime = this.clazz.getDeclaredField("playTime");
            fieldPlayTime.setAccessible(true);
            JLabel playTime = (JLabel)fieldPlayTime.get(player);
            PlayerTest.assertNotNull((String)(String.valueOf(eventSequence) + " currentSong nicht gesetzt"), (Object)currentSong);
            PlayerTest.assertEquals((String)(String.valueOf(eventSequence) + " currentSong falsch"), (String)"wellenmeister - tranquility - 02:21", (String)currentSong.toString());
            String pos1 = playTime.getText();
            this.mySleep(3000L);
            String pos2 = playTime.getText();
            eventSequence = String.valueOf(eventSequence) + "<stop2>";
            player.actionPerformed(new ActionEvent(player, 0, stop.getActionCommand()));
            this.mySleep(3000L);
            PlayerTest.assertTrue((String)(String.valueOf(eventSequence) + " Abspielzeit nicht aktualisiert"), (pos1.compareTo(pos2) < 0 ? 1 : 0) != 0);
        }
        catch (NoSuchFieldException e) {
            PlayerTest.fail((String)("Attribut existiert nicht " + e));
        }
        catch (IllegalAccessException e) {
            PlayerTest.fail((String)e.toString());
        }
        player.dispose();
    }

    private void mySleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private HashMap<String, JButton> fillButtonList(Container traversee, HashMap<String, JButton> map) {
        Component[] componentArray = traversee.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JButton) {
                String buttonName = UNKNOWN;
                String defIcon = ((JButton)c).getIcon().toString();
                if (defIcon.endsWith("play.png")) {
                    buttonName = PLAY;
                } else if (defIcon.endsWith("pause.png")) {
                    buttonName = PAUSE;
                } else if (defIcon.endsWith("stop.png")) {
                    buttonName = STOP;
                } else if (defIcon.endsWith("next.png")) {
                    buttonName = NEXT;
                } else if (defIcon.endsWith("pl_editor.png")) {
                    buttonName = EDITOR;
                }
                map.put(buttonName, (JButton)c);
            } else if (c instanceof Container) {
                this.fillButtonList((Container)c, map);
            }
            ++n2;
        }
        return map;
    }

    private HashMap<String, JButton> fillButtonList(Container traversee) {
        return this.fillButtonList(traversee, new HashMap<String, JButton>());
    }

    public void testInnerClasses() {
        Class<?>[] classes = this.clazz.getDeclaredClasses();
        String c = Arrays.asList(classes).toString();
        PlayerTest.assertTrue((String)"TimerThread nicht als innere Klasse implementiert", (c.indexOf("studiplayer.ui.Player$TimerThread") >= 0 ? 1 : 0) != 0);
        PlayerTest.assertTrue((String)"PlayerThread nicht als innere Klasse implementiert", (c.indexOf("studiplayer.ui.Player$PlayerThread") >= 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < classes.length) {
            if (!classes[i].getName().contains("Player$1") && classes[i].getEnclosingClass() != null) {
                PlayerTest.assertTrue((String)"Innere Klasse ist kein Thread", (boolean)classes[i].getSuperclass().equals(Thread.class));
            }
            ++i;
        }
    }
}

