/*
 * Decompiled with CFR 0.152.
 */
package studiplayer.audio;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import junit.framework.TestCase;
import studiplayer.audio.AudioFile;
import studiplayer.audio.NotPlayableException;
import studiplayer.audio.TaggedFile;
import studiplayer.audio.WavFile;

public class AudioFileTest
extends TestCase {
    private Class clazz = AudioFile.class;
    private AudioFile f1;
    private AudioFile f2;
    private AudioFile f3;

    public AudioFileTest() {
        try {
            this.f1 = new WavFile("wellenmeister - tranquility.wav");
            this.f2 = new TaggedFile("Rock 812.mp3");
            this.f3 = new TaggedFile("wellenmeister_awakening.ogg");
        }
        catch (NotPlayableException e) {
            e.printStackTrace();
        }
    }

    public void testAttributes() {
        Hashtable<String, String> hm = new Hashtable<String, String>();
        hm.put("pathname", "java.lang.String");
        hm.put("author", "java.lang.String");
        hm.put("title", "java.lang.String");
        String attr = null;
        try {
            Iterator iterator = hm.keySet().iterator();
            while (iterator.hasNext()) {
                String attribut;
                attr = attribut = (String)iterator.next();
                Field f = this.clazz.getDeclaredField(attribut);
                f.setAccessible(true);
                AudioFileTest.assertEquals((String)("Typ des Attributs " + attribut), (String)((String)hm.get(attribut)), (String)f.getType().getName());
                int mod = f.getModifiers();
                AudioFileTest.assertFalse((String)("Zugriff auf " + attribut + " beschaenken"), (Modifier.isProtected(mod) || Modifier.isPublic(mod) ? 1 : 0) != 0);
            }
        }
        catch (SecurityException e) {
            AudioFileTest.fail((String)e.toString());
        }
        catch (NoSuchFieldException e) {
            AudioFileTest.fail((String)("Attribut " + attr + " existiert nicht."));
        }
    }

    public void testGetPathname() {
        AudioFileTest.assertEquals((String)"Pfadname nicht korrekt", (String)"wellenmeister - tranquility.wav", (String)this.f1.getPathname());
        AudioFileTest.assertEquals((String)"Pfadname nicht korrekt", (String)"Rock 812.mp3", (String)this.f2.getPathname());
        AudioFileTest.assertEquals((String)"Pfadname nicht korrekt", (String)"wellenmeister_awakening.ogg", (String)this.f3.getPathname());
    }

    public void testToString() {
        AudioFileTest.assertEquals((String)"toString nicht korrekt", (String)"wellenmeister - tranquility - 02:21", (String)this.f1.toString());
        AudioFileTest.assertEquals((String)"toString nicht korrekt", (String)"Eisbach - Rock 812 - The Sea, the Sky - 05:31", (String)this.f2.toString());
        AudioFileTest.assertEquals((String)"toString nicht korrekt", (String)"Wellenmeister - TANOM Part I: Awakening - TheAbsoluteNecessityOfMeaning - 05:55", (String)this.f3.toString());
    }

    public void testNonExisting() {
        try {
            new WavFile("does not exist.wav");
            AudioFileTest.fail((String)"Nicht existente Datei l\u221a\u2202st keine NotPlayableException aus");
        }
        catch (NotPlayableException e) {
            AudioFileTest.assertTrue((boolean)true);
        }
        try {
            new TaggedFile("does not exist.mp3");
            AudioFileTest.fail((String)"Nicht existente Datei l\u221a\u2202st keine NotPlayableException aus");
        }
        catch (NotPlayableException e) {
            AudioFileTest.assertTrue((boolean)true);
        }
    }

    public void testAbstract() {
        int mod = this.clazz.getModifiers();
        AudioFileTest.assertTrue((String)"AudioFile nicht abstrakt", (boolean)Modifier.isAbstract(mod));
    }

    public void testAbstractMethods() {
        Hashtable<String, String> hm = new Hashtable<String, String>();
        hm.put("play", "void");
        hm.put("togglePause", "void");
        hm.put("stop", "void");
        hm.put("getFormattedDuration", "java.lang.String");
        hm.put("getFormattedPosition", "java.lang.String");
        String goneWrong = null;
        try {
            Iterator iterator = hm.keySet().iterator();
            while (iterator.hasNext()) {
                String methName;
                goneWrong = methName = (String)iterator.next();
                Method meth = this.clazz.getDeclaredMethod(methName, null);
                AudioFileTest.assertEquals((String)("Falscher return-Typ f\u221a\u00bar " + methName), (String)meth.getReturnType().getName(), (String)((String)hm.get(methName)));
                int mod = meth.getModifiers();
                AudioFileTest.assertTrue((String)("AudioFile." + methName + " nicht abstrakt"), (boolean)Modifier.isAbstract(mod));
            }
        }
        catch (SecurityException e) {
            AudioFileTest.fail((String)e.toString());
        }
        catch (NoSuchMethodException e) {
            AudioFileTest.fail((String)("Methode " + goneWrong + " existiert nicht"));
        }
    }

    public void testTagRetrieval() {
        try {
            Field fieldAuthor = this.clazz.getDeclaredField("author");
            fieldAuthor.setAccessible(true);
            AudioFileTest.assertEquals((String)"Attribut author hat falschen Wert", (Object)"Eisbach", (Object)fieldAuthor.get(this.f2));
            AudioFileTest.assertEquals((String)"Attribut author hat falschen Wert", (Object)"Wellenmeister", (Object)fieldAuthor.get(this.f3));
            Field fieldTitle = this.clazz.getDeclaredField("title");
            fieldTitle.setAccessible(true);
            AudioFileTest.assertEquals((String)"Attribut title hat falschen Wert", (Object)"Rock 812", (Object)fieldTitle.get(this.f2));
            AudioFileTest.assertEquals((String)"Attribut title hat falschen Wert", (Object)"TANOM Part I: Awakening", (Object)fieldTitle.get(this.f3));
        }
        catch (SecurityException e) {
            AudioFileTest.fail((String)e.toString());
        }
        catch (NoSuchFieldException e) {
            AudioFileTest.fail((String)"Ein gefordertes Attribut existiert nicht.");
        }
        catch (IllegalArgumentException e) {
            AudioFileTest.fail((String)e.toString());
        }
        catch (IllegalAccessException e) {
            AudioFileTest.fail((String)e.toString());
        }
    }

    public void testFields() {
        AudioFileTest.assertEquals((String)"Fields nicht korrekt f\u221a\u00bar WAV", (String)"[wellenmeister, tranquility, , 02:21]", (String)Arrays.asList(this.f1.fields()).toString());
        AudioFileTest.assertEquals((String)"Fields nicht korrekt f\u221a\u00bar MP3", (String)"[Eisbach, Rock 812, The Sea, the Sky, 05:31]", (String)Arrays.asList(this.f2.fields()).toString());
        AudioFileTest.assertEquals((String)"Fields nicht korrekt f\u221a\u00bar OGG", (String)"[Wellenmeister, TANOM Part I: Awakening, TheAbsoluteNecessityOfMeaning, 05:55]", (String)Arrays.asList(this.f3.fields()).toString());
    }

    public void testNrAttributes() {
        AudioFileTest.assertTrue((String)"Hilfsvariablen als Attribute definiert?", (this.clazz.getDeclaredFields().length == 3 ? 1 : 0) != 0);
    }

    public void testNullTags() {
        TaggedFile f = null;
        try {
            f = new TaggedFile("kein.wav.sondern.ogg");
        }
        catch (NotPlayableException e) {
            AudioFileTest.fail((String)"NotPlayableException f\u221a\u00bar TaggedFile's mit null-Tags");
        }
        catch (NullPointerException e) {
            AudioFileTest.fail((String)"NullPointerException f\u221a\u00bar TaggedFile's mit null-Tags");
        }
        try {
            Field fieldAuthor = this.clazz.getDeclaredField("author");
            fieldAuthor.setAccessible(true);
            AudioFileTest.assertEquals((String)"Attribut author hat falschen Wert", (Object)"", (Object)fieldAuthor.get(f));
            AudioFileTest.assertEquals((String)"Attribut author hat falschen Wert", (Object)"", (Object)fieldAuthor.get(f));
            Field fieldTitle = this.clazz.getDeclaredField("title");
            fieldTitle.setAccessible(true);
            AudioFileTest.assertEquals((String)"Attribut title hat falschen Wert", (Object)"kein.wav.sondern", (Object)fieldTitle.get(f));
        }
        catch (Exception e) {
            AudioFileTest.fail((String)e.toString());
        }
    }
}

