/*
 * Decompiled with CFR 0.152.
 */
package studiplayer.audio;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import studiplayer.audio.AudioFile;
import studiplayer.audio.AudioFileFactory;
import studiplayer.audio.NotPlayableException;

public class NotPlayableExceptionTest
extends TestCase {
    public void testConstructors() {
        try {
            throw new NotPlayableException("abc", "def");
        }
        catch (NotPlayableException e) {
            NotPlayableExceptionTest.assertEquals((String)"toString von NotPlayableException", (String)"abc: studiplayer.audio.NotPlayableException: def", (String)e.toString());
            try {
                throw new NotPlayableException("abc", new RuntimeException("def"));
            }
            catch (NotPlayableException e2) {
                NotPlayableExceptionTest.assertEquals((String)"toString von NotPlayableException", (String)"abc: studiplayer.audio.NotPlayableException: java.lang.RuntimeException: def", (String)e2.toString());
                try {
                    throw new NotPlayableException("abc", "def", new RuntimeException("ghi"));
                }
                catch (NotPlayableException e3) {
                    NotPlayableExceptionTest.assertEquals((String)"toString von NotPlayableException", (String)"abc: studiplayer.audio.NotPlayableException: def", (String)e3.toString());
                    NotPlayableExceptionTest.assertEquals((String)"Root-Cause falsch", (String)"java.lang.RuntimeException", (String)e3.getCause().getClass().getName());
                    return;
                }
            }
        }
    }

    private boolean checkException(Method meth) {
        Class<?>[] ex = meth.getExceptionTypes();
        if (ex.length == 0) {
            return false;
        }
        return NotPlayableException.class.equals(ex[0]);
    }

    private boolean checkException(Constructor meth) {
        Class<?>[] ex = meth.getExceptionTypes();
        if (ex.length == 0) {
            return false;
        }
        return NotPlayableException.class.equals(ex[0]);
    }

    public void testDeclarations() {
        try {
            Method meth = AudioFile.class.getMethod("play", new Class[0]);
            NotPlayableExceptionTest.assertTrue((String)(String.valueOf(meth.getName()) + " deklariert keine NotPlayableException"), (boolean)this.checkException(meth));
            Constructor ctor = AudioFile.class.getDeclaredConstructor(String.class);
            NotPlayableExceptionTest.assertTrue((String)(String.valueOf(ctor.getName()) + " deklariert keine NotPlayableException"), (boolean)this.checkException(ctor));
            meth = AudioFileFactory.class.getMethod("getInstance", String.class);
            NotPlayableExceptionTest.assertTrue((String)(String.valueOf(meth.getName()) + " deklariert keine NotPlayableException"), (boolean)this.checkException(meth));
        }
        catch (SecurityException e) {
            NotPlayableExceptionTest.fail((String)e.toString());
        }
        catch (NoSuchMethodException e) {
            NotPlayableExceptionTest.fail((String)"Geforderte Methode existiert nicht");
        }
    }
}

