/*
 * Decompiled with CFR 0.152.
 */
package studiplayer.audio;

import java.io.File;
import java.io.FileWriter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Scanner;
import studiplayer.audio.AlbumComperator;
import studiplayer.audio.AudioFile;
import studiplayer.audio.AudioFileFactory;
import studiplayer.audio.AuthorComperator;
import studiplayer.audio.DurationComperator;
import studiplayer.audio.SortCriterion;
import studiplayer.audio.TitleComperator;

public class PlayList
extends LinkedList<AudioFile> {
    private int current = 0;
    private boolean randomOrder = true;

    public PlayList() {
    }

    public PlayList(String m3u_pfad) {
        this();
        this.loadFromM3U(m3u_pfad);
    }

    @Override
    public boolean add(AudioFile obj) {
        if (obj == null) {
            return false;
        }
        super.add(obj);
        return true;
    }

    public int getCurrent() {
        return this.current;
    }

    public void setRandomOrder(boolean auswahl) {
        auswahl = this.randomOrder;
    }

    public void setCurrent(int tempcurrent) {
        this.current = tempcurrent;
    }

    public AudioFile getCurrentAudioFile() {
        if (this.size() == 0) {
            return null;
        }
        return (AudioFile)this.get(this.getCurrent());
    }

    public void changeCurrent() {
        if (!this.randomOrder) {
            this.current = this.current != this.size() - 1 ? ++this.current : 0;
        } else if (this.current != this.size() - 1) {
            ++this.current;
        } else {
            this.current = 0;
            Collections.shuffle(this);
        }
    }

    public void saveAsM3U(String m3u_pfad) {
        try {
            FileWriter m3u = new FileWriter(m3u_pfad);
            int i = 0;
            while (i < this.size()) {
                String pfad = ((AudioFile)this.get(i)).getPathname();
                m3u.write(String.valueOf(pfad) + "\n");
                ++i;
            }
            m3u.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void loadFromM3U(String m3u_pfad) {
        try {
            Scanner myScanner = new Scanner(new File(m3u_pfad));
            while (myScanner.hasNextLine()) {
                String line_temp = myScanner.nextLine();
                if (line_temp.startsWith("#")) continue;
                try {
                    this.add(AudioFileFactory.getInstance(line_temp));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            myScanner.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void sort(SortCriterion order) {
        if (order.equals((Object)SortCriterion.ALBUM)) {
            Collections.sort(this, new AlbumComperator());
        }
        if (order.equals((Object)SortCriterion.TITLE)) {
            Collections.sort(this, new TitleComperator());
        }
        if (order.equals((Object)SortCriterion.DURATION)) {
            Collections.sort(this, new DurationComperator());
        }
        if (order.equals((Object)SortCriterion.AUTHOR)) {
            Collections.sort(this, new AuthorComperator());
        }
    }
}

