/*
 * Decompiled with CFR 0.152.
 */
package studiplayer.audio;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import junit.framework.TestCase;
import studiplayer.audio.AudioFile;
import studiplayer.audio.NotPlayableException;
import studiplayer.audio.PlayList;
import studiplayer.audio.SortCriterion;
import studiplayer.audio.TaggedFile;
import studiplayer.audio.WavFile;

public class PlayListTest
extends TestCase {
    private Class<PlayList> clazz = PlayList.class;

    public void testSuperClass() {
        PlayListTest.assertEquals((String)"Superklasse falsch", (String)"java.util.LinkedList<studiplayer.audio.AudioFile>", (String)this.clazz.getGenericSuperclass().toString());
    }

    public void testAdd() {
        PlayList pl = new PlayList();
        PlayListTest.assertFalse((String)"Rueckgabewert von add falsch", (boolean)pl.add(null));
        PlayListTest.assertEquals((String)"Null-Eintrag hinzugef\u221a\u00bagt", (int)0, (int)pl.size());
        try {
            pl.add(new TaggedFile("Rock 812.mp3"));
        }
        catch (NotPlayableException e) {
            PlayListTest.fail((String)"TaggedFile konnte nicht erzeugt werden");
        }
        PlayListTest.assertEquals((String)"Eintrag nicht korrekt hinzugef\u221a\u00bagt", (int)1, (int)pl.size());
    }

    public void testGetSetChangeCurrent() {
        Hashtable<String, String> hm = new Hashtable<String, String>();
        hm.put("current", "int");
        hm.put("randomOrder", "boolean");
        String attr = null;
        try {
            Iterator iterator = hm.keySet().iterator();
            while (iterator.hasNext()) {
                String attribut;
                attr = attribut = (String)iterator.next();
                Field f = this.clazz.getDeclaredField(attribut);
                f.setAccessible(true);
                PlayListTest.assertEquals((String)("Typ des Attributs " + attribut), (String)((String)hm.get(attribut)), (String)f.getType().getName());
                int mod = f.getModifiers();
                PlayListTest.assertTrue((String)("Zugriff auf " + attribut + " beschraenken"), (boolean)Modifier.isPrivate(mod));
            }
        }
        catch (SecurityException e) {
            PlayListTest.fail((String)e.toString());
        }
        catch (NoSuchFieldException e) {
            PlayListTest.fail((String)("Attribut " + attr + " existiert nicht."));
        }
        PlayList pl = new PlayList();
        try {
            PlayListTest.assertNull((Object)pl.getCurrentAudioFile());
        }
        catch (IllegalArgumentException e) {
            PlayListTest.fail((String)"getCurrentAudioFile() fuer leere PlayList loest Exception aus");
        }
        try {
            pl.add(new TaggedFile("Rock 812.mp3"));
            pl.add(new WavFile("wellenmeister - tranquility.wav"));
            pl.add(new TaggedFile("wellenmeister_awakening.ogg"));
        }
        catch (NotPlayableException e) {
            PlayListTest.fail((String)"Audiodatei konnte nicht erzeugt werden");
        }
        PlayListTest.assertEquals((String)"Fehler in size", (int)3, (int)pl.size());
        pl.setRandomOrder(false);
        int i = 0;
        while (i < 10) {
            PlayListTest.assertEquals((String)"Falscher Wert fuer current im seriellen Modus", (int)(i % 3), (int)pl.getCurrent());
            pl.changeCurrent();
            ++i;
        }
        pl.setRandomOrder(true);
        HashMap<String, Integer> configurations = new HashMap<String, Integer>();
        int i2 = 0;
        while (i2 < 100) {
            if (i2 % pl.size() == 0) {
                String conf = pl.toString();
                Integer val = (Integer)configurations.get(conf);
                if (val == null) {
                    configurations.put(conf, 1);
                } else {
                    configurations.put(conf, val + 1);
                }
            }
            pl.changeCurrent();
            ++i2;
        }
        PlayListTest.assertEquals((String)"Der Zufallsmodus liefert nicht alle Reihenfolgen", (int)6, (int)configurations.size());
    }

    public void testGetCurrentAudioFile() {
        PlayList pl = new PlayList();
        PlayListTest.assertNull((Object)pl.getCurrentAudioFile());
        try {
            pl.add(new TaggedFile("Rock 812.mp3"));
            pl.add(new WavFile("wellenmeister - tranquility.wav"));
            pl.add(new TaggedFile("wellenmeister_awakening.ogg"));
        }
        catch (NotPlayableException e) {
            PlayListTest.fail((String)"Audiodatei konnte nicht erzeugt werden");
        }
        pl.setCurrent(1);
        AudioFile f1 = pl.getCurrentAudioFile();
        PlayListTest.assertEquals((String)"getCurrentAudioFile gibt falsche Datei zur\u221a\u00back", (String)"wellenmeister - tranquility - 02:21", (String)f1.toString());
        pl.setCurrent(0);
        AudioFile f0 = pl.getCurrentAudioFile();
        PlayListTest.assertEquals((String)"getCurrentAudioFile gibt falsche Datei zur\u221a\u00back", (String)"Eisbach - Rock 812 - The Sea, the Sky - 05:31", (String)f0.toString());
    }

    public void testM3U() {
        PlayList pl1 = new PlayList();
        try {
            pl1.add(new TaggedFile("Rock 812.mp3"));
            pl1.add(new WavFile("wellenmeister - tranquility.wav"));
            pl1.add(new TaggedFile("wellenmeister_awakening.ogg"));
        }
        catch (NotPlayableException e) {
            PlayListTest.fail((String)"Audiodatei konnte nicht erzeugt werden");
        }
        String m3uName = "pl.m3u";
        pl1.saveAsM3U("pl.m3u");
        File m3u = new File("pl.m3u");
        PlayListTest.assertTrue((String)"M3U-Datei wird nicht angelegt", (boolean)m3u.exists());
        try {
            FileWriter fw = new FileWriter(m3u, true);
            String sep = System.getProperty("line.separator");
            fw.write("# comment" + sep);
            fw.write("# fake.ogg" + sep);
            fw.close();
        }
        catch (IOException e) {
            PlayListTest.fail((String)e.toString());
        }
        pl1 = null;
        PlayList pl2 = new PlayList("pl.m3u");
        PlayListTest.assertEquals((String)"Play-List aus M3U-Datei laden fehlerhaft", (String)"[Eisbach - Rock 812 - The Sea, the Sky - 05:31, wellenmeister - tranquility - 02:21, Wellenmeister - TANOM Part I: Awakening - TheAbsoluteNecessityOfMeaning - 05:55]", (String)pl2.toString());
    }

    public void testLoadM3UAbbruch() {
        try {
            new PlayList("does not exist.m3u");
            PlayListTest.fail((String)"Haette PlayList nicht erzeugen koennen");
        }
        catch (RuntimeException e) {
            PlayListTest.assertTrue((boolean)true);
        }
    }

    public void testLenientLoadM3U() {
        String m3uName = "pl.m3u";
        File m3u = new File("pl.m3u");
        PlayListTest.assertTrue((String)"M3U-Datei wird nicht angelegt", (boolean)m3u.exists());
        try {
            FileWriter fw = new FileWriter(m3u);
            fw.write("gibt es nicht.wav\n");
            fw.write("und das auch nicht.ogg\n");
            fw.write("und das - sowieso nicht.mp3\n");
            fw.close();
        }
        catch (IOException e) {
            PlayListTest.fail((String)e.toString());
        }
        PlayList pl = null;
        try {
            pl = new PlayList("pl.m3u");
        }
        catch (Exception e) {
            PlayListTest.fail((String)"PlayList sollte nicht-existente Dateien ignorieren");
        }
        PlayListTest.assertEquals((String)"PlayList erzeugt fuer nicht-existente Dateien Eintraege", (int)0, (int)pl.size());
    }

    public void testSorting() {
        PlayList pl1 = new PlayList();
        try {
            pl1.add(new TaggedFile("Rock 812.mp3"));
            pl1.add(new WavFile("wellenmeister - tranquility.wav"));
            pl1.add(new TaggedFile("wellenmeister_awakening.ogg"));
        }
        catch (NotPlayableException e) {
            PlayListTest.fail((String)"Audiodatei konnte nicht erzeugt werden");
        }
        pl1.sort(SortCriterion.ALBUM);
        PlayListTest.assertEquals((String)"Sortierung nach Album nicht richtig", (String)"[wellenmeister - tranquility - 02:21, Eisbach - Rock 812 - The Sea, the Sky - 05:31, Wellenmeister - TANOM Part I: Awakening - TheAbsoluteNecessityOfMeaning - 05:55]", (String)pl1.toString());
        pl1.sort(SortCriterion.AUTHOR);
        PlayListTest.assertEquals((String)"Sortierung nach Interpret nicht richtig", (String)"[Eisbach - Rock 812 - The Sea, the Sky - 05:31, Wellenmeister - TANOM Part I: Awakening - TheAbsoluteNecessityOfMeaning - 05:55, wellenmeister - tranquility - 02:21]", (String)pl1.toString());
        pl1.sort(SortCriterion.DURATION);
        PlayListTest.assertEquals((String)"Sortierung nach Dauer nicht richtig", (String)"[wellenmeister - tranquility - 02:21, Eisbach - Rock 812 - The Sea, the Sky - 05:31, Wellenmeister - TANOM Part I: Awakening - TheAbsoluteNecessityOfMeaning - 05:55]", (String)pl1.toString());
        pl1.sort(SortCriterion.TITLE);
        PlayListTest.assertEquals((String)"Sortierung nach Titel nicht richtig", (String)"[Eisbach - Rock 812 - The Sea, the Sky - 05:31, Wellenmeister - TANOM Part I: Awakening - TheAbsoluteNecessityOfMeaning - 05:55, wellenmeister - tranquility - 02:21]", (String)pl1.toString());
    }

    public void testMultipleShuffle() {
        PlayList pl = new PlayList();
        try {
            pl.add(new TaggedFile("Rock 812.mp3"));
            pl.add(new WavFile("wellenmeister - tranquility.wav"));
            pl.add(new TaggedFile("wellenmeister_awakening.ogg"));
            pl.add(new TaggedFile("Rock 812.mp3"));
            pl.add(new WavFile("wellenmeister - tranquility.wav"));
            pl.add(new TaggedFile("wellenmeister_awakening.ogg"));
        }
        catch (NotPlayableException e) {
            PlayListTest.fail((String)("Song nicht abspielbar:" + e.getMessage()));
        }
        String s1 = pl.toString();
        pl.changeCurrent();
        String s2 = pl.toString();
        pl.changeCurrent();
        String s3 = pl.toString();
        PlayListTest.assertTrue((String)"Shuffle bei jedem PlayList.changeCurrent", (s1.equals(s2) || s2.equals(s3) ? 1 : 0) != 0);
    }
}

