/*
 * Decompiled with CFR 0.152.
 */
package studiplayer.audio;

import java.util.Map;
import studiplayer.audio.NotPlayableException;
import studiplayer.audio.SampledFile;
import studiplayer.basic.TagReader;

class TaggedFile
extends SampledFile {
    private String album = "";

    public String getAlbum() {
        return this.album;
    }

    public TaggedFile(String variable) throws NotPlayableException {
        super(variable);
        try {
            Map map = TagReader.readTags((String)variable);
            String aut = (String)map.get("author");
            String tit = (String)map.get("title");
            String alb = (String)map.get("album");
            Long dur = (Long)map.get("duration");
            if (aut != null) {
                this.author = aut.trim();
            }
            if (tit != null) {
                this.title = tit.trim();
            }
            if (alb != null) {
                this.album = alb.trim();
            }
            if (dur != null) {
                this.duration = dur;
            }
        }
        catch (Exception e) {
            throw new NotPlayableException(this.getPathname(), e);
        }
    }

    @Override
    public String toString() {
        String erg = super.toString();
        erg = !this.album.isEmpty() ? String.valueOf(erg) + " - " + this.album + " - " + this.getFormattedDuration() : String.valueOf(erg) + " - " + this.getFormattedDuration();
        return erg;
    }

    @Override
    public String[] fields() {
        String[] erg = new String[4];
        String mmss = this.getFormattedDuration();
        if (this.author == null) {
            this.author = "";
        }
        if (this.title == null) {
            this.title = "";
        }
        if (this.album == null) {
            this.album = "";
        }
        if (mmss == null) {
            mmss = "";
        }
        erg[0] = this.author;
        erg[1] = this.title;
        erg[2] = this.album;
        erg[3] = mmss;
        return erg;
    }
}

