/*
 * Decompiled with CFR 0.152.
 */
package studiplayer.audio;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import junit.framework.TestCase;
import studiplayer.audio.NotPlayableException;
import studiplayer.audio.TaggedFile;

public class TaggedFileTest
extends TestCase {
    private Class clazz = TaggedFile.class;
    private TaggedFile f1;
    private TaggedFile f2;

    public TaggedFileTest() {
        try {
            this.f1 = new TaggedFile("Rock 812.mp3");
            this.f2 = new TaggedFile("wellenmeister_awakening.ogg");
        }
        catch (NotPlayableException e) {
            e.printStackTrace();
        }
    }

    public void testSuperClass() {
        TaggedFileTest.assertEquals((String)"TaggedFile nicht von SampledFile abgeleitet", (String)"studiplayer.audio.SampledFile", (String)this.clazz.getSuperclass().getName());
    }

    public void testAttributes() {
        try {
            Field fieldAlbum = this.clazz.getDeclaredField("album");
            TaggedFileTest.assertEquals((String)"album ist kein String", (String)"java.lang.String", (String)fieldAlbum.getType().getName());
            int mod = fieldAlbum.getModifiers();
            TaggedFileTest.assertTrue((String)"album sollte private sein", (boolean)Modifier.isPrivate(mod));
        }
        catch (SecurityException e) {
            TaggedFileTest.fail((String)e.toString());
        }
        catch (NoSuchFieldException e) {
            TaggedFileTest.fail((String)"Ein gefordertes Attribut existiert nicht.");
        }
    }

    public void testConstructor() {
        try {
            Constructor ctor = this.clazz.getDeclaredConstructor(String.class);
        }
        catch (SecurityException e) {
            TaggedFileTest.fail((String)e.toString());
        }
        catch (NoSuchMethodException e) {
            TaggedFileTest.fail((String)"TaggedFile(String) gibt es nicht");
        }
    }

    public void testTagRetrieval() {
        try {
            Field fieldAlbum = this.clazz.getDeclaredField("album");
            fieldAlbum.setAccessible(true);
            TaggedFileTest.assertEquals((String)"Attribut album hat falschen Wert", (Object)"The Sea, the Sky", (Object)fieldAlbum.get(this.f1));
            TaggedFileTest.assertEquals((String)"Attribut album hat falschen Wert", (Object)"TheAbsoluteNecessityOfMeaning", (Object)fieldAlbum.get(this.f2));
        }
        catch (SecurityException e) {
            TaggedFileTest.fail((String)e.toString());
        }
        catch (NoSuchFieldException e) {
            TaggedFileTest.fail((String)"Ein gefordertes Attribut existiert nicht.");
        }
        catch (IllegalArgumentException e) {
            TaggedFileTest.fail((String)e.toString());
        }
        catch (IllegalAccessException e) {
            TaggedFileTest.fail((String)e.toString());
        }
    }

    public void testToString() {
        TaggedFileTest.assertEquals((String)"Falsche Formatierung durch TaggedFile.toString", (String)"Eisbach - Rock 812 - The Sea, the Sky - 05:31", (String)this.f1.toString());
        TaggedFileTest.assertEquals((String)"Falsche Formatierung durch TaggedFile.toString", (String)"Wellenmeister - TANOM Part I: Awakening - TheAbsoluteNecessityOfMeaning - 05:55", (String)this.f2.toString());
    }

    public void testInvalid() {
        try {
            new TaggedFile("Rock 812.cut.mp3");
            TaggedFileTest.fail((String)"NotPlayableException erwartet fuer fehlerhafte MP3-Datei!");
        }
        catch (NotPlayableException e) {
            TaggedFileTest.assertTrue((boolean)true);
        }
    }
}

