/*
 * Decompiled with CFR 0.152.
 */
package studiplayer.audio;

import studiplayer.audio.NotPlayableException;
import studiplayer.audio.SampledFile;
import studiplayer.basic.WavParamReader;

public class WavFile
extends SampledFile {
    public WavFile(String Dateiname) throws NotPlayableException {
        super(Dateiname);
        try {
            WavParamReader.readParams((String)Dateiname);
            float framrate = WavParamReader.getFrameRate();
            float anzframe = WavParamReader.getNumberOfFrames();
            float microsecounds = 1000000.0f * (anzframe / framrate);
            this.duration = (long)microsecounds;
        }
        catch (Exception e) {
            throw new NotPlayableException(this.getPathname(), e);
        }
        this.fields();
    }

    @Override
    public String toString() {
        String erg = super.toString();
        erg = String.valueOf(erg) + " - " + this.getFormattedDuration();
        return erg;
    }

    @Override
    public String[] fields() {
        String[] erg = new String[4];
        String mmss = this.getFormattedDuration();
        if (this.author == null) {
            this.author = "";
        }
        if (this.title == null) {
            this.title = "";
        }
        if (mmss == null) {
            mmss = "";
        }
        erg[0] = this.author;
        erg[1] = this.title;
        erg[2] = "";
        erg[3] = mmss;
        return erg;
    }
}

