/*
 * Decompiled with CFR 0.152.
 */
package studiplayer.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import studiplayer.audio.PlayList;
import studiplayer.ui.PlayListEditor;

public class Player
extends JFrame
implements ActionListener {
    private JLabel songDescription = new JLabel();
    private JLabel playTime = new JLabel();
    private boolean stopped = true;
    private boolean editorVisible = false;
    String temp1 = "";
    private static PlayList playList = new PlayList();
    private static PlayListEditor playListEditor = new PlayListEditor(null, playList);
    public static final String DEFAULT_PLAYLIST = "playList.m3u";
    JButton play = new JButton(new ImageIcon(this.getClass().getResource("play.png")));
    JButton pause = new JButton(new ImageIcon(this.getClass().getResource("pause.png")));
    JButton stop = new JButton(new ImageIcon(this.getClass().getResource("stop.png")));

    Player(PlayList pl) {
        this.setDefaultCloseOperation(3);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JPanel buttons = new JPanel();
        this.playTime.setText("00:00");
        this.play.setActionCommand("AC_PLAY");
        this.play.addActionListener(this);
        buttons.add(this.play);
        this.pause.setActionCommand("AC_PAUSE");
        this.pause.addActionListener(this);
        this.pause.setEnabled(false);
        buttons.add(this.pause);
        this.stop.setActionCommand("AC_STOP");
        this.stop.addActionListener(this);
        this.stop.setEnabled(false);
        buttons.add(this.stop);
        JButton next = new JButton(new ImageIcon(this.getClass().getResource("next.png")));
        next.setActionCommand("AC_NEXT");
        next.addActionListener(this);
        buttons.add(next);
        JButton pleditor = new JButton(new ImageIcon(this.getClass().getResource("pl_editor.png")));
        pleditor.setActionCommand("AC_EDITOR");
        pleditor.addActionListener(this);
        buttons.add(pleditor);
        this.add((Component)this.playTime, "West");
        this.add((Component)this.songDescription, "North");
        if (playList.isEmpty()) {
            this.songDescription.setText("Kein Lied ausgew\u00e4hlt.");
            this.setTitle("Kein Lied ausgew\u00e4hlt.");
        } else {
            this.songDescription.setText(playList.getCurrentAudioFile().toString());
            this.playTime.setText(playList.getCurrentAudioFile().getFormattedPosition());
            this.setTitle(playList.getCurrentAudioFile().toString());
        }
        this.add((Component)this.playTime, "West");
        this.add((Component)this.songDescription, "North");
        this.add((Component)buttons, "East");
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        System.out.println(cmd);
        if (cmd.equals("AC_PLAY")) {
            System.out.println("checkPLAY");
            this.playCurrentSong();
            this.pause.setEnabled(true);
            this.stop.setEnabled(true);
            this.play.setEnabled(false);
        } else if (cmd.equals("AC_PAUSE")) {
            System.out.println("checkPAUSE");
            if (!playList.isEmpty()) {
                playList.getCurrentAudioFile().togglePause();
            }
            this.pause.setEnabled(true);
            this.stop.setEnabled(true);
            this.play.setEnabled(false);
        } else if (cmd.equals("AC_STOP")) {
            System.out.println("checkSTOP");
            this.stopCurrentSong();
            this.pause.setEnabled(false);
            this.stop.setEnabled(false);
            this.play.setEnabled(true);
        } else if (cmd.equals("AC_NEXT")) {
            System.out.println("checkNEXT");
            if (!this.stopped) {
                this.stopCurrentSong();
                playList.changeCurrent();
                this.playCurrentSong();
            } else {
                this.songDescription.setText(playList.getCurrentAudioFile().toString());
                this.playTime.setText(playList.getCurrentAudioFile().getFormattedPosition());
            }
            this.pause.setEnabled(true);
            this.stop.setEnabled(true);
            this.play.setEnabled(false);
        } else if (cmd.equals("AC_EDITOR")) {
            playListEditor.setVisible(true);
            System.out.println("check");
        }
    }

    private void stopCurrentSong() {
        this.stopped = true;
        this.playTime.setText("00:00");
        if (!playList.isEmpty()) {
            playList.getCurrentAudioFile().stop();
        }
    }

    private void playCurrentSong() {
        this.stopped = false;
        new TimerThread().start();
        new PlayerThread().start();
    }

    public static void main(String[] args) {
        PlayList pla = args.length > 0 ? new PlayList(args[0]) : (new File(DEFAULT_PLAYLIST).exists() ? new PlayList(DEFAULT_PLAYLIST) : new PlayList());
        Player playerm = new Player(pla);
    }

    private class PlayerThread
    extends Thread {
        private PlayerThread() {
        }

        @Override
        public void run() {
            try {
                while (!Player.this.stopped && !playList.isEmpty()) {
                    Player.this.songDescription.setText(playList.getCurrentAudioFile().toString());
                    Player.this.setTitle(playList.getCurrentAudioFile().toString());
                    playList.getCurrentAudioFile().play();
                    playList.changeCurrent();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class TimerThread
    extends Thread {
        private TimerThread() {
        }

        @Override
        public void run() {
            try {
                while (!Player.this.stopped && !playList.isEmpty()) {
                    Player.this.playTime.setText(playList.getCurrentAudioFile().getFormattedPosition());
                    TimerThread.sleep(1000L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

